<?php

namespace App\Http\Controllers;

use App\Helpers\ApiResponse;
use App\Models\Interest;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class InterestController extends Controller
{
    public function index(): JsonResponse
    {
        $interests = Interest::select('id','name')->orderBy('name')->get();

        return ApiResponse::success(
            "Interest list fetched successfully",
            $interests
        );
    }

    public function me(Request $request): JsonResponse
    {
        $user = $request->user(); // Sanctum user

        $user->load('interests');

        return ApiResponse::success(
            "Interest list fetched successfully",
            $user
        );
    }
}
