<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name'      => 'required|string|max:255',
            'email'     => ['required','email', Rule::unique('users','email')->ignore($this->id)],
            'location'  => 'nullable|string|max:255',
            'bio'       => 'nullable|string',
            'interests'   => ['nullable'],
            'interests.*' => ['integer', 'exists:interests,id'],
            // 'countries' => 'nullable|array',
            // 'countries.*' => 'string|max:100',
            // 'status'    => 'required|in:active,suspended,pending',
            'image'     => 'nullable|image|max:2048',
        ];
    }
}
