<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\UserResource;

class TravelPlanResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'                 => $this->id,
            'title'              => $this->title,
            'short_description'  => $this->short_description,
            'user_id'            => $this->user_id,
            'destination'        => $this->destination,
            'start_date'         => $this->start_date,
            'end_date'           => $this->end_date,
            'budget'             => $this->budget,
            'travel_type'        => $this->travel_type,
            'itinerary'          => $this->itinerary,
            'group_size'         => $this->group_size,
            'status'             => $this->status,
            'created_at'         => $this->created_at,
            'updated_at'         => $this->updated_at,

            // ⭐ Map User -> UserResource
            'host' => new UserResource($this->host),
            'participants' => $this->participants
        ];
    }
}
