<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class UserResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'    => $this->id,
            'name'  => $this->name,
            'email' => $this->email,
            'role'  => $this->role,
            'bio'  => $this->bio,
            'imageUrl' => isset($this->image_url) && Storage::disk('public')->exists($this->image_url) ? url("public/storage/{$this->image_url}") : $this->image_url,
            'location'  => $this->location,
            'age'  => $this->age,
            'rating_avg'  => $this->rating_avg,
            'rating_count'  => $this->rating_count,
            'createdAt' => $this->whenHas('created_at', fn() => $this->created_at->toDateTimeString()),
        ];
    }
}
