<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TravelPlan extends Model
{
    protected $fillable = [
        'user_id',
        'title',
        'short_description',
        'destination',
        'start_date',
        'end_date',
        'budget',
        'travel_type',
        'itinerary',
        'group_size',
        'status'
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date'   => 'date',
        'itinerary' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function host(): BelongsTo {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function participants()
    {
        return $this->hasMany(TravelPlanParticipant::class);
    }

    public function interests()
    {
        return $this->belongsToMany(Interest::class, 'travel_plan_interests');
    }

}
