<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id();

            $table->foreignId('travel_plan_id')
                ->constrained('travel_plans')
                ->onDelete('cascade');

            // Who is giving the review
            $table->foreignId('reviewer_id')
                ->constrained('users')
                ->onDelete('cascade');

            // Who is being reviewed (usually the host, or another member)
            $table->foreignId('reviewed_user_id')
                ->constrained('users')
                ->onDelete('cascade');

            $table->tinyInteger('rating'); // 1–5
            $table->text('comment')->nullable();

            $table->timestamps();

            // One review per (trip, reviewer, reviewed_user)
            $table->unique(
                ['travel_plan_id', 'reviewer_id', 'reviewed_user_id'],
                'unique_trip_reviewer_reviewed'
            );
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reviews');
    }
};
