<?php

// use App\Http\Controllers\API\AuthController;
// use App\Http\Controllers\API\UserController;
use App\Http\Controllers\InterestController;
use App\Http\Controllers\TravelPlanController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Client\DestinationController;
use App\Http\Controllers\Client\TravelerController;
use App\Http\Controllers\Auth\AuthController;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\ReviewController;


Route::get('/storage-link', function() {
    Artisan::call('storage:link');
    return "ok";
});


     /*
    |--------------------------------------------------------------------------
    | PUBLIC RESOURCES
    |--------------------------------------------------------------------------
    */
    Route::get('destinations/popular', [DestinationController::class, 'popular']);
    Route::get('travelers/top-rated', [TravelerController::class, 'topRated']);


    Route::get('/users', [UserController::class, 'index']);
    Route::get('/users/interests', [UserController::class, 'getUserWithInterest']);
    Route::post('/users', [UserController::class, 'store']);
    Route::get('/users/{id}', [UserController::class, 'show']);
    Route::put('/users/{id}', [UserController::class, 'update']);
    Route::delete('/users/{id}', [UserController::class, 'destroy']);


    Route::get('/interests', [InterestController::class, 'index']);
    Route::get('/me/interests', [InterestController::class, 'me'])->middleware('auth:sanctum');


    Route::get('/travel-plans/match', [TravelPlanController::class, 'match']);


    Route::get('/travel-plans/upcoming-trips', [TravelPlanController::class, 'upcomingTrips']);
    Route::apiResource('travel-plans', TravelPlanController::class);


    Route::middleware('auth:sanctum')->group(function () {
        Route::post('/travel-plans/{id}/join', [TravelPlanController::class, 'join']);
        Route::post('/travel-plans/{id}/approve', [TravelPlanController::class, 'approve']);
        Route::post('/travel-plans/{id}/decline', [TravelPlanController::class, 'decline']);


        Route::post('/reviews', [ReviewController::class, 'store']);        // Add review
        Route::patch('/reviews/{review}', [ReviewController::class, 'update']); // Edit review
        Route::delete('/reviews/{review}', [ReviewController::class, 'destroy']); // Delete review
    });


    // Route::get('/users/{user}/reviews', [ReviewController::class, 'reviewsForUser']);
    Route::get('/user-reviews/{user}', [ReviewController::class, 'reviewsForUser']);

    Route::post('/auth/register', [AuthController::class, 'register']);
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::post('/auth/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');



    // Route::get('interests', [InterestController::class, 'index']);
    // Route::get('users',     [UserController::class, 'index']);
    // Route::get('users/{id}',[UserController::class, 'show']);

    // Route::get('plans',               [TravelPlanController::class, 'index']);
    // Route::get('plans/{id}',          [TravelPlanController::class, 'show']);
    // Route::get('search/travelers',    [SearchController::class, 'travelers']);
    // Route::get('search/plans',        [SearchController::class, 'plans']);
    // Route::get('search/match/{uid}',  [SearchController::class, 'match']);
